<?php
/* --------------------------------------------------------------
   StorageOfMultipleParcelServicesRequested.php 2020-03-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Events;

use Gambio\Admin\ParcelService\Interfaces\ParcelServices;

/**
 * Class StorageOfMultipleParcelServicesRequested
 *
 * @package Gambio\Admin\ParcelService\Events
 */
class StorageOfMultipleParcelServicesRequested
{
    /**
     * @var ParcelServices
     */
    private $parcelServices;
    
    
    /**
     * StorageOfMultipleParcelServicesRequested constructor.
     *
     * @param ParcelServices $parcelServices
     */
    private function __construct(ParcelServices $parcelServices)
    {
        $this->parcelServices = $parcelServices;
    }
    
    
    /**
     * @param ParcelServices $parcelServices
     *
     * @return StorageOfMultipleParcelServicesRequested
     */
    public static function create(ParcelServices $parcelServices): StorageOfMultipleParcelServicesRequested
    {
        return new self($parcelServices);
    }
    
    
    /**
     * @return ParcelServices
     */
    public function parcelServices(): ParcelServices
    {
        return $this->parcelServices;
    }
    
    
    /**
     * @param ParcelServices $parcelServices
     */
    public function replaceParcelServices(ParcelServices $parcelServices): void
    {
        $this->parcelServices = $parcelServices;
    }
}